GameSettings = {
    music_volume = 0.5,
    sound_volume = 1,
    full_screen = true,
}


function GameSettings:load()
    if file_exists("settings.txt") then
        local data = file_load_lua_table("settings.txt")
        self.music_volume = data.music_volume
        self.sound_volume = data.sound_volume
        self.full_screen = data.full_screen
        log("Loaded game settings")
    end
end


function GameSettings:save()
    local data = ""
    data = data.."music_volume = "..self.music_volume..",\n"
    data = data.."sound_volume = "..self.sound_volume..",\n"
    data = data.."full_screen = "..tostring(self.full_screen)..",\n"

    file_save("settings.txt", data)
    log("Saved game settings")
end


function load_game_settings()
    game_settings = GameSettings
    game_settings:load()
end
